<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Blog extends Model 
{

    protected $table = 'blogs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function blogPost()
    {
        return $this->hasMany('App\Classes\BlogPost');
    }

    public function profile()
    {
        return $this->belongsTo('App\Classes\Profile');
    }

}